/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.bridge.NativeBridge;
import com.ibm.hwmca.fw.bridge.NativeBridgeException;
import com.ibm.hwmca.fw.util.FTPException;
import com.ibm.hwmca.fw.util.NativeProcessParameters;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;

public class FTP {
    public static final String FTP_GUEST_ROOT_DIRECTORY = "/console/ftp/";
    public static final int FTP_WRITE_TYPE_APPEND = 1;
    public static final int FTP_WRITE_TYPE_OVERWRITE = 2;
    public static final int FTP_TRANSFER_TYPE_ASCII = 1;
    public static final int FTP_TRANSFER_TYPE_IMAGE = 2;
    public static final int FTP_TRANSFER_TYPE_TEXT = 1;
    public static final int FTP_TRANSFER_TYPE_BINARY = 2;
    private static final String FTPUTILS_LIBRARY_NAME = "actzftputils";
    private static final String NATIVE_BRIDGE_MAIN_PROGRAM = "actzNativeBridgeMain";
    private static final String NATIVE_BRIDGE_DELETE_FUNCTION = "java_ftp_delete";
    private static final String NATIVE_BRIDGE_DIR_FUNCTION = "java_ftp_dir";
    private static final String NATIVE_BRIDGE_NLST_FUNCTION = "java_ftp_nlst";
    private static final String NATIVE_BRIDGE_GET_FUNCTION = "java_ftp_get";
    private static final String NATIVE_BRIDGE_PUT_FUNCTION = "java_ftp_put";
    private static final String NATIVE_BRIDGE_ADD_GUEST_USER_FUNCTION = "java_ftp_add_guest_user";
    private static final String NATIVE_BRIDGE_SET_GUEST_USER_PASSWORD_FUNCTION = "java_ftp_set_guest_user_password";
    private static final String NATIVE_BRIDGE_REMOVE_GUEST_USER_FUNCTION = "java_ftp_remove_guest_user";
    private static final int FTP_ERR_PARM_HOSTPORT = 1;
    private static final int FTP_ERR_PARM_USERID = 2;
    private static final int FTP_ERR_PARM_PASSWORD = 3;
    private static final int FTP_ERR_PARM_LOCAL_FILENAME = 4;
    private static final int FTP_ERR_PARM_REMOTE_FILENAME = 5;
    private static final int FTP_ERR_PARM_WRITE_TYPE = 6;
    private static final int FTP_ERR_PARM_TRANSFER_TYPE = 7;
    private static final int FTP_ERR_PARM_HOME_DIRECTORY = 8;
    private static final int FTP_ERR_CONNECT = 9;
    private static final int FTP_ERR_LOGIN = 10;
    private static final int FTP_ERR_GET = 11;
    private static final int FTP_ERR_PUT = 12;
    private static final int FTP_ERR_DELETE = 13;
    private static final int FTP_ERR_DIR = 14;
    private static final int FTP_ERR_NLST = 15;
    private static final int FTP_SPAWN_FAILED = 16;
    private static final int FTP_CHILD_SIGNAL_EXIT = 17;
    private static final int FTP_WAITPID_FAILED = 18;
    private static final int FTP_FILE_ACTIONS_ADDCLOSE_FAILED = 19;
    private static final int FTP_FILE_ACTIONS_INIT_FAILED = 20;
    private static final int FTP_SPAWNING_PROGRAM_ERROR = 21;
    private static final int FTP_EXTERNAL_PROGRAM_ERROR = 22;
    private static final String TRACE_MASKT = "XREMFTPT";
    private static final String TRACE_MASKF = "XREMFTPF";
    private static final String TRACE_MASKD = "XREMFTPD";

    public static void addFTPGuestUser(String userid, String password, String homeDirectory) throws FTPException {
        Trace.trace(TRACE_MASKT, "-> addFTPGuestUser");
        NativeProcessParameters parms = new NativeProcessParameters(NATIVE_BRIDGE_MAIN_PROGRAM);
        Object[] args = new Object[]{userid, password, homeDirectory};
        Trace.trace(TRACE_MASKF, "FTP.addFTPGuestUser() about to call invokeNativeFunction() for function=java_ftp_add_guest_user, userid=" + userid + ", homeDirectory=" + homeDirectory);
        Trace.trace(TRACE_MASKD, "password=" + password);
        try {
            NativeBridge.invokeNativeFunction(parms, FTPUTILS_LIBRARY_NAME, NATIVE_BRIDGE_ADD_GUEST_USER_FUNCTION, args);
        }
        catch (IOException ioe) {
            throw new FTPException(7, (Throwable)ioe);
        }
        catch (NativeBridgeException nbe) {
            FTP.handleNativeBridgeException(nbe);
        }
        Trace.trace(TRACE_MASKT, "<- addFTPGuestUser");
    }

    public static void setFTPGuestUserPassword(String userid, String password) throws FTPException {
        Trace.trace(TRACE_MASKT, "-> setFTPGuestUserPassword");
        NativeProcessParameters parms = new NativeProcessParameters(NATIVE_BRIDGE_MAIN_PROGRAM);
        Object[] args = new Object[]{userid, password};
        Trace.trace(TRACE_MASKF, "FTP.setFTPGuestUserPassword() about to call invokeNativeFunction() for function=java_ftp_set_guest_user_password, userid=" + userid);
        Trace.trace(TRACE_MASKD, "password=" + password);
        try {
            NativeBridge.invokeNativeFunction(parms, FTPUTILS_LIBRARY_NAME, NATIVE_BRIDGE_SET_GUEST_USER_PASSWORD_FUNCTION, args);
        }
        catch (IOException ioe) {
            throw new FTPException(7, (Throwable)ioe);
        }
        catch (NativeBridgeException nbe) {
            FTP.handleNativeBridgeException(nbe);
        }
        Trace.trace(TRACE_MASKT, "<- setFTPGuestUserPassword");
    }

    public static void removeFTPGuestUser(String userid) throws FTPException {
        Trace.trace(TRACE_MASKT, "-> removeFTPGuestUser");
        NativeProcessParameters parms = new NativeProcessParameters(NATIVE_BRIDGE_MAIN_PROGRAM);
        Object[] args = new Object[]{userid};
        Trace.trace(TRACE_MASKF, "FTP.removeFTPGuestUser() about to call invokeNativeFunction() for function=java_ftp_remove_guest_user, userid=" + userid);
        try {
            NativeBridge.invokeNativeFunction(parms, FTPUTILS_LIBRARY_NAME, NATIVE_BRIDGE_REMOVE_GUEST_USER_FUNCTION, args);
        }
        catch (IOException ioe) {
            throw new FTPException(7, (Throwable)ioe);
        }
        catch (NativeBridgeException nbe) {
            FTP.handleNativeBridgeException(nbe);
        }
        Trace.trace(TRACE_MASKT, "<- removeFTPGuestUser");
    }

    public static void delete(String hostPort, String userid, String password, String remoteFilename) throws FTPException {
        Trace.trace(TRACE_MASKT, "-> delete");
        NativeProcessParameters parms = new NativeProcessParameters(NATIVE_BRIDGE_MAIN_PROGRAM);
        Object[] args = new Object[]{hostPort, userid, password, remoteFilename};
        Trace.trace(TRACE_MASKF, "FTP.delete() about to call invokeNativeFunction() for function=java_ftp_delete, userid=" + userid + ", remoteFilename=" + remoteFilename);
        Trace.trace(TRACE_MASKD, "password=" + password);
        try {
            NativeBridge.invokeNativeFunction(parms, FTPUTILS_LIBRARY_NAME, NATIVE_BRIDGE_DELETE_FUNCTION, args);
        }
        catch (IOException ioe) {
            throw new FTPException(7, (Throwable)ioe);
        }
        catch (NativeBridgeException nbe) {
            FTP.handleNativeBridgeException(nbe);
        }
        Trace.trace(TRACE_MASKT, "<- delete");
    }

    public static void dir(String hostPort, String userid, String password, String localOutputFilename, String remoteFilename) throws FTPException {
        Trace.trace(TRACE_MASKT, "-> dir");
        NativeProcessParameters parms = new NativeProcessParameters(NATIVE_BRIDGE_MAIN_PROGRAM);
        Object[] args = new Object[]{hostPort, userid, password, localOutputFilename, remoteFilename};
        Trace.trace(TRACE_MASKF, "FTP.dir() about to call invokeNativeFunction() for function=java_ftp_dir, userid=" + userid + ", localOutputFilename=" + localOutputFilename + ", remoteFilename=" + remoteFilename);
        Trace.trace(TRACE_MASKD, "password=" + password);
        try {
            NativeBridge.invokeNativeFunction(parms, FTPUTILS_LIBRARY_NAME, NATIVE_BRIDGE_DIR_FUNCTION, args);
        }
        catch (IOException ioe) {
            throw new FTPException(7, (Throwable)ioe);
        }
        catch (NativeBridgeException nbe) {
            FTP.handleNativeBridgeException(nbe);
        }
        Trace.trace(TRACE_MASKT, "<- dir");
    }

    public static void nlst(String hostPort, String userid, String password, String localOutputFilename, String remoteFilename) throws FTPException {
        Trace.trace(TRACE_MASKT, "-> nlst");
        NativeProcessParameters parms = new NativeProcessParameters(NATIVE_BRIDGE_MAIN_PROGRAM);
        Object[] args = new Object[]{hostPort, userid, password, localOutputFilename, remoteFilename};
        Trace.trace(TRACE_MASKF, "FTP.nlst() about to call invokeNativeFunction() for function=java_ftp_nlst, userid=" + userid + ", localOutputFilename=" + localOutputFilename + ", remoteFilename=" + remoteFilename);
        Trace.trace(TRACE_MASKD, "password=" + password);
        try {
            NativeBridge.invokeNativeFunction(parms, FTPUTILS_LIBRARY_NAME, NATIVE_BRIDGE_NLST_FUNCTION, args);
        }
        catch (IOException ioe) {
            throw new FTPException(7, (Throwable)ioe);
        }
        catch (NativeBridgeException nbe) {
            FTP.handleNativeBridgeException(nbe);
        }
        Trace.trace(TRACE_MASKT, "<- nlst");
    }

    public static void get(String hostPort, String userid, String password, String localFilename, String remoteFilename, int writeType, int transferType) throws FTPException {
        Trace.trace(TRACE_MASKT, "-> get");
        NativeProcessParameters parms = new NativeProcessParameters(NATIVE_BRIDGE_MAIN_PROGRAM);
        Object[] args = new Object[]{hostPort, userid, password, localFilename, remoteFilename, new Integer(writeType), new Integer(transferType)};
        Trace.trace(TRACE_MASKF, "FTP.get() about to call invokeNativeFunction() for function=java_ftp_get, userid=" + userid + ", localFilename=" + localFilename + ", remoteFilename=" + remoteFilename + ", writeType=" + writeType + ", transferType=" + transferType);
        Trace.trace(TRACE_MASKD, "password=" + password);
        try {
            NativeBridge.invokeNativeFunction(parms, FTPUTILS_LIBRARY_NAME, NATIVE_BRIDGE_GET_FUNCTION, args);
        }
        catch (IOException ioe) {
            throw new FTPException(7, (Throwable)ioe);
        }
        catch (NativeBridgeException nbe) {
            FTP.handleNativeBridgeException(nbe);
        }
        Trace.trace(TRACE_MASKT, "<- get");
    }

    public static void put(String hostPort, String userid, String password, String localFilename, String remoteFilename, int transferType) throws FTPException {
        Trace.trace(TRACE_MASKT, "-> put");
        NativeProcessParameters parms = new NativeProcessParameters(NATIVE_BRIDGE_MAIN_PROGRAM);
        Object[] args = new Object[]{hostPort, userid, password, localFilename, remoteFilename, new Integer(transferType)};
        Trace.trace(TRACE_MASKF, "FTP.put() about to call invokeNativeFunction() for function=java_ftp_put, userid=" + userid + ", localFilename=" + localFilename + ", remoteFilename=" + remoteFilename + ", transferType=" + transferType);
        Trace.trace(TRACE_MASKD, "password=" + password);
        try {
            NativeBridge.invokeNativeFunction(parms, FTPUTILS_LIBRARY_NAME, NATIVE_BRIDGE_PUT_FUNCTION, args);
        }
        catch (IOException ioe) {
            throw new FTPException(7, (Throwable)ioe);
        }
        catch (NativeBridgeException nbe) {
            FTP.handleNativeBridgeException(nbe);
        }
        Trace.trace(TRACE_MASKT, "<- put");
    }

    private static void handleNativeBridgeException(NativeBridgeException nbe) throws FTPException {
        int reasonCode;
        boolean isLogged = false;
        Trace.trace(TRACE_MASKF, "Native bridge error code = " + nbe.getErrorCode());
        if (nbe.areReturnCodesSet()) {
            int src = nbe.getSystemReturnCode();
            int crc = nbe.getComponentReturnCode();
            Trace.trace(TRACE_MASKF, "System return code = " + src + "; component return code = " + crc);
            if (src == 2) {
                switch (crc) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        reasonCode = 1;
                        break;
                    }
                    case 9: {
                        reasonCode = 2;
                        break;
                    }
                    case 10: {
                        reasonCode = 3;
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        reasonCode = 4;
                        break;
                    }
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: {
                        reasonCode = 8;
                        break;
                    }
                    case 22: {
                        reasonCode = 9;
                        break;
                    }
                    default: {
                        reasonCode = 5;
                        break;
                    }
                }
            } else {
                switch (src) {
                    case 1: {
                        reasonCode = 10;
                        break;
                    }
                    case 4: {
                        reasonCode = 11;
                        break;
                    }
                    case 8: {
                        reasonCode = 12;
                        isLogged = true;
                        break;
                    }
                    case 12: {
                        reasonCode = 13;
                        isLogged = true;
                        break;
                    }
                    default: {
                        reasonCode = 5;
                    }
                }
            }
        } else {
            reasonCode = 6;
        }
        FTPException ftpe = new FTPException(reasonCode, (Throwable)nbe);
        ftpe.setLogged(isLogged);
        throw ftpe;
    }
}

